/* demonstrates plotting a graph for cos(x) */
#include <ezwin.h>
#include <iostream>
#include <cassert>
#include <cmath>
using namespace std;
// Define a 10cm x 10cm window, with title appropriate title
SimpleWindow MyWindow("Graph for trigonometric functions", 10.0, 10.0,Position(1.0, 1.0));
int ApiMain() {
	MyWindow.Open();
	
	assert(MyWindow.GetStatus() == WindowOpen);

	float x,y, rad;

	MyWindow.RenderLine(Position(0.1,0.1), Position(0.1, 10),Black, 0.0);
		 //Draw Y axis
	MyWindow.RenderLine(Position(0.1, 5), Position(10, 5),Black, 0.0);
		 //Draw X axis
	rad = 3.14159/5; // 2 pi should be equal to 10

	for(x=0.0;x<10.0;x+=0.001) 
	{
	y = cos(x*rad); // y is between -1 and 1
	y = 3*y; // scale it from -3 to 3
	MyWindow.RenderLine(Position(x+0.1,y+5), Position(x+0.1,y+5), Blue, 0.0);
	}
return 0;

}
